//
//  TTTCheckpointManager.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 11/23/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTCheckpointManager.h"

@implementation TTTCheckpointManager

    static TTTCheckpointManager *singletonManager=nil;


    +(TTTCheckpointManager *) CreateManager{
        @synchronized([TTTCheckpointManager class]){
            if (singletonManager == nil){
                singletonManager = [[TTTCheckpointManager alloc] init];
                singletonManager->managedObjects = [[NSMutableDictionary alloc] init];
            }
            return singletonManager;
        }
    }

    -(id) init{
        return self;
    }

    -(void) registerObjectWithKey :(NSString *) key :(NSObject *) objectToBeManaged{
        [managedObjects setObject :objectToBeManaged forKey:key];
    }

    -(void) unregisterObjectWithKey :(NSString *) key{
        [managedObjects removeObjectForKey :key];
    }

    -(void) checkpoint{
        NSEnumerator *enumerator = [managedObjects keyEnumerator];
        id oneKey;
        while ((oneKey = [enumerator nextObject])) {
            NSObject *oneObject = [managedObjects objectForKey:oneKey];
            SEL checkpointMethodSEL = NSSelectorFromString(@"checkpoint");
            [oneObject performSelector:checkpointMethodSEL];
        }
    }


@end
